﻿<%@ Page language="c#" codePage="1200" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Ksiega.Forms" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Analiza płatności - dla dokumentów</title>
		<script runat="server">
	
            //Raport wg wpisanej nazwy cechy. 
            //UWAGA! Działa tylko jeżeli raport dla kontrahentów
            //Poniżej należy uzupełnić wszystkie 3 wartości, są to:
            //1. Nazwa cechy kontrahenta        
            const string wgWartościCechy = "";
            //2. Nazwa słownika 
            const string wgWartościDictionary = "";
            //3. Etykieta wyświetlana podczas pytania o wartość pola
            const string wgWartościLabel = "";		    
		    
	public enum Zakres {
		Razem, Kontrahenci, Pracownicy, Urzędy
	}
	
	class Podsumowanie {
		readonly IPodmiotKasowy podmiot;
		string numer;
		Date data;
		Date termin;
		String terminDniStr;
		readonly bool należności;
		
		decimal razem;
		decimal niezapłacone;
        decimal zapłacono;
		decimal terminowe;

        decimal d7;
        decimal d14;
        decimal d30;
        decimal p30;

        bool warunek =false;

		public Podsumowanie(RozrachunekIdx idx, bool należności,StanRozliczeniaRozrachunkuWorker worker) 
		{
			worker.RozrachunekIdx = idx;
			
		    this.podmiot = idx.Podmiot;
			this.należności = należności;
		    data = idx.Data;
		    termin = idx.Termin;

			if (termin.IsNull)
				terminDniStr = String.Empty;
			else if (termin == Platnosc.MaxTermin)
				terminDniStr = "(max)";
			else
				terminDniStr = (termin - data).ToString();
		    
		    Date dataRoz = idx.DataRozliczenia;
		    numer = idx.Numer;    
			decimal kwota = idx.Kwota.Value;
			razem = kwota;

            if (termin == Date.Empty || dataRoz <= termin)
            {
                terminowe = kwota;
                zapłacono = kwota;
            }
            else
            {
                d7 = 0;
                d14 = 0;
                d30 = 0;
                p30 = 0;
                terminowe = 0;
                foreach (Soneta.Kasa.RozliczenieSP Zapl in idx.Dokument.Zaplaty){
                    int d = Zapl.Zaplata.DataDokumentu - termin;
                    if (d <= 0)
                        terminowe += Zapl.KwotaZaplaty.Value;
                    else if (d <= 7)
                        d7 += Zapl.KwotaZaplaty.Value;
                    else if (d <= 14)
                        d14 += Zapl.KwotaZaplaty.Value;
                    else if (d <= 30)
                        d30 += Zapl.KwotaZaplaty.Value;
                    else
                        p30 += Zapl.KwotaZaplaty.Value;
                }
                decimal de = idx.KwotaRozliczona.Value;
                
                //kwota rozliczona mniejsza od kwoty rozrachunku
                if (de < kwota)
                    zapłacono = de;
                else 
                    zapłacono = kwota;
                
                niezapłacone = kwota - de;

            }
			if (worker.IsReversed)
			{
				Reverse();
			}
		}
		
		
        public Podsumowanie(RozrachunekIdx idx, bool należności, FromTo dataRozlicz,StanRozliczeniaRozrachunkuWorker worker)
		{
			worker.RozrachunekIdx = idx;
			
            this.podmiot = idx.Podmiot;
            this.należności = należności;
            data = idx.Data;
            termin = idx.Termin;

			if (termin.IsNull)
				terminDniStr = String.Empty;
			else if (termin == Platnosc.MaxTermin)
				terminDniStr = "(max)";
			else
				terminDniStr = (termin - data).ToString();

            Date dataRoz = idx.DataRozliczenia;
            numer = idx.Numer;
            decimal kwota = idx.Kwota.Value;
            razem = kwota;

            //if (termin == Date.Empty || dataRoz <= termin)
            //calosciowe
            if ((termin == Date.Empty || dataRoz <= termin) && dataRozlicz.Contains(dataRoz))
            {
                warunek = true;
                terminowe = kwota;
                zapłacono = kwota;
            }
            //czesciowe
            else
            {
                d7 = 0;
                d14 = 0;
                d30 = 0;
                p30 = 0;
                terminowe = 0;
                
                foreach (Soneta.Kasa.RozliczenieSP Zapl in idx.Dokument.Zaplaty)
                {
                    if (dataRozlicz.Contains(Zapl.Zaplata.DataDokumentu)){
                        warunek = true;
                    int d = Zapl.Zaplata.DataDokumentu - termin;
                    if (d <= 0)
                        terminowe += Zapl.KwotaZaplaty.Value;
                    else if (d <= 7)
                        d7 += Zapl.KwotaZaplaty.Value;
                    else if (d <= 14)
                        d14 += Zapl.KwotaZaplaty.Value;
                    else if (d <= 30)
                        d30 += Zapl.KwotaZaplaty.Value;
                    else
                        p30 += Zapl.KwotaZaplaty.Value;
                    }
                }
                //jesli byla wplata w tym terminie
                if (warunek){
                    zapłacono = terminowe + d7 + d14 + d30 + p30;
                    niezapłacone = kwota - zapłacono;
                }

            }
			if (worker.IsReversed)
			{
				Reverse();
			}
        }


		private void Reverse()
		{
			razem = -razem;
			niezapłacone = -niezapłacone;
			zapłacono = -zapłacono;
			terminowe = -terminowe;

			d7 = -d7;
			d14 = -d14;
			d30 = -d30;
			p30 = -p30;
		}
		
		
		
		public IPodmiotKasowy Podmiot {
			get { return podmiot; }
		}		
		public Date Termin {
			get { return termin; }
		}
		public String TerminDniStr
		{
			get { return terminDniStr; }
		}
		public Date Data {
			get { return data; }
		}
		public string Numer {
			get { return numer; }
		}
		public decimal Razem {
			get { return razem; }
		}
		public decimal Niezapłacone {
			get { return niezapłacone; }
		}
        public decimal Zapłacono{
            get { return zapłacono; }
		}
		public decimal Terminowe {
			get { return terminowe; }
		}
        public decimal D7
        {
			get { return d7; }
		}
        public decimal D14
        {
			get { return d14; }
		}
        public decimal D30
        {
			get { return d30; }
		}
        public decimal P30
        {
			get { return p30; }
		}
        public bool Warunek
        {
            get { return warunek; }
        }
	}
	
	public enum TypDokumentów {
		Zobowiązania, Należności
	}
	
	public class PrnParams: Soneta.Business.OkresContext {
		public PrnParams(Context context): base(context) {
			waluta = WalutyModule.GetInstance(this).Waluty.PLN;
			if (Context.Contains(typeof(OkresContext)))
				base.Okres = ((OkresContext)Context[typeof(OkresContext)]).Okres;
		}
		
		[Priority(0)]
		[Browsable(false)]
		public override Date Aktualny {
			get { return base.Aktualny; }
			set { base.Aktualny = value; }
		}

		[Priority(1)]
		public override FromTo Okres {
			get { return base.Okres; }
			set
			{
				base.Okres = value.IsNull ? FromTo.All : value; 

			}
		}

        FromTo dataRozliczenia =FromTo.All;
        [Priority(2)]
        [Caption("Termin rozliczenia")]
        public FromTo DataRozliczenia
        {
            get { return dataRozliczenia; }
            set { dataRozliczenia = value; }
        }
		Zakres zakres = Zakres.Kontrahenci;
		[Priority(3)]
		public Zakres Zakres {
			get { return zakres; }
			set { 
				zakres = value; 
				OnChanged(EventArgs.Empty);
			}
		}

		public RowCondition Condition() {
			switch (zakres) {
				case Zakres.Kontrahenci:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
				case Zakres.Pracownicy:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
				case Zakres.Urzędy:
					RowCondition condition = RowCondition.Empty;
					condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					return new RowCondition.Not(condition);
				default:
					return RowCondition.Empty;
			}
		}
		
		IPodmiotKasowy odk;
		[Caption("Od kontrahenta")]
		[Priority(4)]
		public IPodmiotKasowy Od {
			get { return odk; }
			set { 
				odk = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		IPodmiotKasowy dok;
		[Priority(5)]
		[Caption("Do kontrahenta")]
		public IPodmiotKasowy Do {
			get { return dok; }
			set { 
				dok = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        string wartośćCechy = "";
        [Priority(6)]
        [Caption(wgWartościLabel)]
        [Browsable(wgWartościLabel != "")]
        [Dictionary(wgWartościDictionary)]
        public string WartośćCechy {
            get { return wartośćCechy; }
            set {
                wartośćCechy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyWartośćCechy() {
            return wgWartościCechy == "" || zakres != Zakres.Kontrahenci;
        }        
        
		TypDokumentów dokumenty = TypDokumentów.Należności;
		[Priority(7)]
		public TypDokumentów Dokumenty {
			get { return dokumenty; }
			set { 
				dokumenty = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
        RodzajDokumentów rodzaj = RodzajDokumentów.Płatności;
		[Priority(8)]
        [Caption("Rodzaj")]
        public RodzajDokumentów Rodzaj {
            get { return rodzaj; }
            set { 
                rodzaj = value;
                OnChanged(EventArgs.Empty);
            }
        }		
		
		Waluta waluta;
		[Priority(9)]
		[Required]
		public Waluta Waluta {
			get { return waluta; }
			set { 
				waluta = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		string aktualneKonto = "";
		[Priority(11)]
		public string AktualneKonto
		{
			get { return aktualneKonto; }
			set
			{
				aktualneKonto = value.ToUpper();
				OnChanged(EventArgs.Empty);
			}
		}	
	}
	
	
	
	private PrnParams pars = null;
	private WydrukiRozrachunkowFiltr wr = new WydrukiRozrachunkowFiltr();

	
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 

	[Context(Required = true)]
	public WydrukOddzialParams OParams { get; set; }

	
	void OnContextLoad(object sender, EventArgs e) 
	{
        if(pars.DataRozliczenia.IsNull)
            throw new InvalidOperationException("Niepoprawna data w polu 'Termin rozliczenia'.");    
		
		bool należności = pars.Dokumenty==TypDokumentów.Należności;

		wr.PodmiotOd = pars.Od;
		wr.PodmiotDo = pars.Do;
		wr.Waluta = pars.Waluta;
		wr.SetAktualneKonto(pars.AktualneKonto, pars.Aktualny);
		wr.SetFeature(wgWartościCechy, pars.WartośćCechy);

		KasaModule kasa = KasaModule.GetInstance(pars);
		RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
		Soneta.Business.View view = rozrachunki.Wszystkie(null, pars.Okres);
		view.Condition &= pars.Condition();
		view.Condition &= OParams.GetConditionIdx();

        RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
            należności && pars.Rodzaj!=RodzajDokumentów.Zapłaty,
            !należności && pars.Rodzaj!=RodzajDokumentów.Zapłaty,
            !należności && pars.Rodzaj!=RodzajDokumentów.Płatności,
            należności && pars.Rodzaj!=RodzajDokumentów.Płatności);
        if (condition!=RowCondition.Empty)
            view.Condition &= condition;
		
        ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
        ReportHeader1["DATAROZLICZENIA"] = "|</strong>Termin rozliczenia: <strong>" + pars.DataRozliczenia +"</strong>";
		ReportHeader1["TYP"] = należności ? "należności" : "zobowiązań";
		ReportHeader1["KONTRAHENT"] = wr.GetTitleStringPodmiot();
		ReportHeader1["KONTO"] = wr.GetTitleStringKonto();
		ReportHeader1["WALUTA"] = wr.GetTitleStringWaluta(false);



		if (pars.Zakres == Zakres.Razem)
			ReportHeader1["ZAKRES"] = "";
		else
			ReportHeader1["ZAKRES"] = "|</strong>Zakres: <strong>" + pars.Zakres;

		if (pars.Rodzaj == RodzajDokumentów.Razem)
			ReportHeader1["RODZAJ"] = "";
		else
			ReportHeader1["RODZAJ"] = "|</strong>Rodzaj: <strong>" + pars.Rodzaj;

        if (pars.Zakres != Zakres.Kontrahenci || pars.WartośćCechy == "")
            ReportHeader1["WGCECHY"] = "";
        else
            ReportHeader1["WGCECHY"] = string.Format("|</strong>{0}: <strong> {1}", wgWartościCechy, pars.WartośćCechy);


		StanRozliczeniaRozrachunkuWorker worker = new StanRozliczeniaRozrachunkuWorker();
		worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;
		
		ArrayList lista = new ArrayList();
		wr.SetFilter(view);

        if (pars.DataRozliczenia.Equals(FromTo.All))
		{
            foreach (RozrachunekIdx idx in view)
                   lista.Add(new Podsumowanie(idx, należności,worker));
        }
        else
		{
            foreach (RozrachunekIdx idx in view)
                if ((new Podsumowanie(idx, należności, pars.DataRozliczenia,worker)).Warunek)
                {
                    lista.Add(new Podsumowanie(idx, należności, pars.DataRozliczenia,worker));
                }
        }

		        
		Grid1.DataSource = lista;
	}

 
	
		</script>
	</HEAD>
	<body>
		<form id="StrukturaWiekowaNaleznosciKontrahenci" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" Landscape="True" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:reportheader id="ReportHeader1" title="Analiza %TYP% - dla dokumentów|%ODDZIAL%</strong>Za okres: <strong>{0}%RODZAJ%%ZAKRES%%WGCECHY%%DATAROZLICZENIA%%KONTRAHENT%%WALUTA%%KONTO%"
				runat="server" ContextTypeName="Soneta.Business.OkresContext,Soneta.Business" DataMember0="Okres"></cc1:reportheader><ea:grid id="Grid1" runat="server" RowsInRow="1">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="Podmiot.Kod" Caption="Kod kontrahenta" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Numer" Caption="Dokument~Numer" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Center" DataMember="Data" Caption="Dokument~Data" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Center" DataMember="TerminDniStr" Total="Info" Caption="Dokument~Termin" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Razem" Total="Sum" Caption="Dokument~Kwota"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Niezapłacone" Total="Sum" Caption="Niezapłacone"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Zapłacono" Total="Sum" Caption="Zapłacono"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="Terminowe" Total="Sum" Caption="Dokonane wpłaty~terminowe"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="D7" Total="Sum" Caption="Dokonane wpłaty~od 1 do 7"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="D14" Total="Sum" Caption="Dokonane wpłaty~od 8 do 14"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="D30" Total="Sum" Caption="Dokonane wpłaty~od 15 do 30"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="P30" Total="Sum" Caption="Dokonane wpłaty~ponad 30"
						HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
		</form>
	</body>
</HTML>
